DEBUG_MODE = False
USE_CUDA = True
CUDA_DEVICE_NUM = 0


##########################################################################################
# Path Config

import os
import sys

os.chdir(os.path.dirname(os.path.abspath(__file__)))
sys.path.insert(0, "..")  # for problem_def
sys.path.insert(0, "../..")  # for utils

import logging

from utils import create_logger
from SMTWTTester import SMTWTTester as Tester


##########################################################################################
pomo_size = 128

env_params = {
    'job_cnt': 50,
    'pomo_size':pomo_size,
}
 
model_params = {
    'embedding_dim': 128,
    'sqrt_embedding_dim': 128**(1/2),
    'decoder_layer_num': 5,
    'qkv_dim': 16,
    'sqrt_qkv_dim': 16**(1/2),
    'head_num': 8,
    'ff_hidden_dim': 512,
    'eval_type': 'softmax', 
    'latent_cont_size':4,
    'latent_disc_size':12,
    'temperature': 1,
    'pomo_size':pomo_size
}

tester_params = {
    'use_cuda': USE_CUDA,
    'cuda_device_num': CUDA_DEVICE_NUM,
    'model_load': {
        'path': './result/saved_SMTWT50',  # directory path of pre-trained model and log files saved.
        'epoch': 100,  # epoch version of pre-trained model to load.
    },
    'epochs':1,
    'test_batch_size': 100,
}

logger_params = {
    'log_file': {
        'desc': 'SMTWT_Test',
        'filename': 'log.txt'
    }
}

##########################################################################################
def main():

    if DEBUG_MODE:
        _set_debug_mode()

    create_logger(**logger_params)
    _print_config()

    tester = Tester(env_params=env_params,
                    model_params=model_params,
                    tester_params=tester_params)

    tester.run()

def _print_config():
    logger = logging.getLogger('root')
    logger.info('DEBUG_MODE: {}'.format(DEBUG_MODE))
    logger.info('USE_CUDA: {}, CUDA_DEVICE_NUM: {}'.format(USE_CUDA, CUDA_DEVICE_NUM))
    [logger.info(g_key + "{}".format(globals()[g_key])) for g_key in globals().keys() if g_key.endswith('params')]

def _set_debug_mode():
    global tester_params
    tester_params['test_episodes'] = 10

##########################################################################################
if __name__ == "__main__":
    main()